<?php
error_reporting(0);
session_status() === PHP_SESSION_NONE && session_start();
class XAntibot
{
    private $apiKey;
    private $apiUrl = 'https://xantibot.net/api/shortlink';
    
    public function __construct($apiKey , $keyname)
    {
        $this->apiKey   = $apiKey;
        $this->keyname  = $keyname;
    }
    public function headers() {
        if (function_exists('getallheaders')) {
            $headers = getallheaders();
        } else {
            $headers = [];
            foreach ($_SERVER as $name => $value) {
                if (substr($name, 0, 5) == 'HTTP_') {
                    $key = str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))));
                    $headers[$key] = $value;
                }
            }
        }

        $headerModify = [];
        foreach ($headers as $key => $value) {
            $headerModify[strtolower($key)] = $value;
        }
        return $headerModify;
    }
    public function getAcceptLanguageList($header = null) {
    
        $langs = [];
    
        foreach (explode(',', $header) as $lang) {
            $lang = trim($lang);
            $q = 1.0;
    
            if (strpos($lang, ';q=') !== false) {
                list($lang, $qVal) = explode(';q=', $lang);
                $q = (float)$qVal;
            }
    
            $langs[$lang] = $q;
        }
    
        arsort($langs); // urutkan berdasarkan q tertinggi
    
        return implode(',', array_keys($langs));
    }
    public function getClientIp()
    {
        $ipKeys = [
            'HTTP_CF_CONNECTING_IP', 
            'HTTP_X_FORWARDED_FOR',
            'HTTP_X_REAL_IP',
            'HTTP_CLIENT_IP',
            'REMOTE_ADDR'
        ];
        
        foreach ($ipKeys as $key) {
            if (!empty($_SERVER[$key])) {
                $ip = $_SERVER[$key];
                if (strpos($ip, ',') !== false) {
                    $ip = trim(explode(',', $ip)[0]);
                }
                if (filter_var($ip, FILTER_VALIDATE_IP)) {
                    return $ip;
                }
            }
        }
        
        return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    }
    public function makeRequest($url)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        $error = curl_error($ch);
        curl_close($ch);
        if ($error) {
            error_log("Antibot API Error: " . $error);
            return null;
        }
        return json_decode($response,true);
    }
    public function redirect($url)
    {
        header("Location: " . $url);
        exit;
    }
    public function check(){
        $header     = $this->headers();
        $clientIp   = $this->getClientIp();
        
        if($header['accept-language']){
            $data['lang']       = $this->getAcceptLanguageList($header['accept-language']);
        }
        if($header['user-agent']){
            $data['useragent']  = ($header['user-agent'] ? $header['user-agent']:'');
        }
        $data['ip']             = $clientIp;
        $data['apikey']         = $this->apiKey;
        $data['keyname']        = $this->keyname;
        
        $url        = $this->apiUrl . '?' . http_build_query($data);
        $request    = $this->makeRequest($url);
        return $request;
    }
}


