<?php
$configFile = __DIR__ . '/../config.json';
$htaccess   = __DIR__ . '/../.htaccess';

// lock kalau sudah install
if (file_exists($configFile)) {
    http_response_code(403);
    exit('Already installed');
}

// validasi minimal
$apikey   = $_POST['apikey']   ?? null;
$user     = $_POST['username'] ?? null;
$pass     = $_POST['password'] ?? null;
$action   = $_POST['bot_action'] ?? 'challenge';
$redirect = $_POST['bot_redirect_path'] ?? '';

if (!$apikey || !$user || !$pass) {
    http_response_code(400);
    exit('Missing parameter');
}

// normalisasi
$allowedAction = ['challenge', 'redirect'];
if (!in_array($action, $allowedAction, true)) {
    $action = 'challenge';
}

$data = [
    'apikey' => trim($apikey),
    'username' => trim($user),
    'password' => $pass,
    'bot' => [
        'action' => $action,
        'redirect_path' => $action === 'redirect' ? trim($redirect) : null
    ],
    'installed_at' => date('c')
];

file_put_contents($configFile,json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES), LOCK_EX);

$htaccessContent = <<<HTACCESS
<Files "config.json">
    Order allow,deny
    Deny from all
</Files>
RewriteEngine On
RewriteBase /

RewriteCond %{REQUEST_FILENAME} -f [OR]
RewriteCond %{REQUEST_FILENAME} -d
RewriteRule ^ - [L]

RewriteRule ^r/([^/]+)/?$ xantibot_handler.php?keyname=\$1 [L,QSA]
RewriteRule ^k/([^/]+)/?$ xantibot_handler.php?keyname=\$1 [L,QSA]
RewriteRule ^go/([^/]+)/?$ xantibot_handler.php?keyname=\$1 [L,QSA]

RewriteRule ^([^/]+)/?$ xantibot_handler.php?keyname=\$1 [L,QSA]
HTACCESS;
if (file_put_contents($htaccess, $htaccessContent) === false) {
    die("Failed to write .htaccess\n");
}

die(header("Location: ../manage.php"));
