<?php
session_start();

$configPath = __DIR__.'/config.json';
if(!file_exists($configPath)){
    die('Config file not found');
}

$config = json_decode(file_get_contents($configPath), true);
if(empty($config['apikey'])){
    die('API key not configured');
}

$host = $_SERVER['HTTP_HOST'];
$scheme = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$fullUrl = $scheme . '://' . $host;

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    if($_POST['username'] === $config['username'] && $_POST['password'] === $config['password']){
        $_SESSION['logged_in'] = true;
    } else {
        $error = "Invalid credentials!";
    }
}
if(!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']){
    echo '
    <div id="loginModal" style="position:fixed;top:0;left:0;width:100%;height:100%;background:#000a;color:#fff;display:flex;align-items:center;justify-content:center;">
        <form method="post" style="background:#111;padding:2rem;border:1px solid #0f0;">
            <h2>Login</h2>
            <input type="text" name="username" placeholder="Username" required><br><br>
            <input type="password" name="password" placeholder="Password" required><br><br>
            <button type="submit">Login</button>
            <p style="color:red;">'.($error ?? "").'</p>
        </form>
    </div>';
    exit;
}
?>

<!DOCTYPE html>
<html lang="en" class="min-h-full">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>URL Shortener - Responsive</title>

<script src="https://cdn.tailwindcss.com"></script>
<link href="https://fonts.googleapis.com/css2?family=Fira+Code:wght@300;400;500;600;700&display=swap" rel="stylesheet">

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>

<style>
body {
    font-family: 'Fira Code', monospace;
    background-color: #050505;
    color: #00ff41;
    overflow-x: hidden;
}
.crt::before {
    content: " ";
    display: block;
    position: absolute;
    top:0; left:0; bottom:0; right:0;
    background: linear-gradient(rgba(18,16,16,0) 50%, rgba(0,0,0,0.25) 50%), linear-gradient(90deg, rgba(255,0,0,0.06), rgba(0,255,0,0.02), rgba(0,0,255,0.06));
    z-index: 2;
    background-size: 100% 2px, 3px 100%;
    pointer-events: none;
}
.blink { animation: blink-animation 1s steps(2, start) infinite; }
@keyframes blink-animation { to { visibility: hidden; } }

table.dataTable thead th { color:#00ff41; border-bottom:1px solid #0f0; }
table.dataTable tbody td a { color:#0ff; text-decoration:underline; word-break: break-all; }
table.dataTable tbody tr:hover { background-color: rgba(0,255,65,0.05); }

input, button { font-family: 'Fira Code', monospace; }
input {
    background:#000; border:1px solid rgba(0,255,65,0.3); color:#00ff41; padding:0.5rem; width:100%;
}
input:focus { outline:none; border-color:#00ff41; box-shadow:0 0 10px rgba(0,255,65,0.3); }
button { background:#000; border:1px solid #00ff41; color:#00ff41; padding:0.5rem 1rem; cursor:pointer; transition:all 0.2s; }
button:hover { background: rgba(0,255,65,0.05); box-shadow: 0 0 10px rgba(0,255,65,0.3); }

@media(max-width:640px){
    h1 { font-size:1.75rem; }
    table.dataTable td, table.dataTable th { font-size:0.75rem; padding:0.25rem 0.5rem; }
    button { padding:0.4rem 0.6rem; font-size:0.75rem; }
}
.fade-in { animation: fadeIn 0.5s ease-in; }
@keyframes fadeIn { from {opacity:0; transform:translateY(-10px);} to {opacity:1; transform:translateY(0);} }
.url-row:hover { background-color: rgba(0,255,65,0.05); border-left:3px solid #00ff41; }
.copy-btn { background: rgba(0,255,65,0.05); border:none; color:#ffff00; cursor:pointer; font-family:'Fira Code', monospace; padding:0 4px; }
.copy-btn:disabled { color:#888; cursor:default; }
</style>
</head>
<body class="crt relative min-h-screen">

<div class="max-w-5xl mx-auto p-4">

    <h1 class="text-3xl font-bold mb-4">URL SHORTENER <span class="blink">_</span></h1>

    <div class="bg-black border border-green-500/50 p-4 mb-6 rounded-sm">
        <form id="urlForm" class="space-y-4">
            <div>
                <label class="block mb-1">Short :</label>
                <input type="url" id="original_url" required placeholder="https://example.com/your-very-long-url" />
            </div>
            <div>
                <label class="block mb-1">Custom/Keyname :</label>
                <input type="text" id="custom_code" pattern="[a-zA-Z0-9-_]+" maxlength="20" placeholder="custom-code" />
            </div>
            <div class="flex gap-2">
                <button type="button" onclick="window.location.href='https://xantibot.pw/account/shortlink'" class="px-4 py-2">> GENERATE</button>
                <button type="reset" class="px-4 py-2 text-sm font-bold uppercase tracking-normal border border-red-500/50 text-red-500 hover:bg-red-500/10 transition-all">CLEAR</button>
            </div>
        </form>
    </div>
    
    <div class="mb-4 text-xs text-green-400/60">
        <p>> Untuk hapus/edit/delete silakan ke dashboard <a href="https://xantibot.pw/account/shortlink" class="text-red-500 underline">Xantibot Shorturl</a></p>
        <p>> To delete/edit/manage your links, please go to the dashboard <a href="https://xantibot.pw/account/shortlink" class="text-red-500 underline">Xantibot Shorturl</a></p>
    </div>

    <div class="bg-black border border-green-500/50 p-4 rounded-sm overflow-x-auto">
        <table id="shortlinksTable" class="display w-full">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Original URL</th>
                    <th>Short Code</th>
                    <th>Created At</th>
                    <th>Clicks</th>
                </tr>
            </thead>
            <tbody></tbody>
            <tfoot>
                <tr>
                    <th colspan="4" class="text-right">Total Clicks:</th>
                    <th id="totalClicks"></th>
                </tr>
            </tfoot>
        </table>
    </div>

</div>

<script>
$(document).ready(function() {
    let table;
    let totalClicks = 0;
    const apiUrl = "https://xantibot.pw/api/shortlink-list?apikey=<?=$config['apikey'];?>";

    function renderTable(data){
        totalClicks = data.reduce((sum,row)=>sum+row.count,0);

        if($.fn.DataTable.isDataTable('#shortlinksTable')) table.clear().destroy();

        table = $('#shortlinksTable').DataTable({
            responsive: true,
            data: data.map((row,index)=>[
                '#' + (index+1),
                `<a href="${row.url}" target="_blank">${row.url}</a>`,
                `<span class="short-url"><?=$fullUrl;?>/${row.keyname}</span> <button class="copy-btn">COPY</button>`,
                row.at_create,
                row.count
            ]),
            columns: [
                {title:"ID"},
                {title:"Original URL"},
                {title:"Short Code"},
                {title:"Created At"},
                {title:"Clicks"}
            ],
            order:[[0,"asc"]],
            paging:true,
            searching:true
        });

        $('#totalClicks').text(totalClicks.toLocaleString());
    }

    function loadShortlinks(){
        $.getJSON(apiUrl,function(response){
            if(response.status==="success") renderTable(response.data);
        });
    }

    loadShortlinks();
    setInterval(loadShortlinks,30000); // auto refresh setiap 30 detik

    $('#shortlinksTable').on('click','.copy-btn',function(){
        const text = $(this).prev('.short-url').text();
        navigator.clipboard.writeText(text);
        $(this).text('COPIED!').prop('disabled',true);
        setTimeout(()=>$(this).text('COPY').prop('disabled',false),2000);
    });

    $('#urlForm').on('submit', function(e){
        e.preventDefault();
        const url = $('#original_url').val();
        const code = $('#custom_code').val() || Math.random().toString(36).substring(2,8);
        const date = new Date().toISOString().slice(0,19).replace('T',' ');
        const clicks = 0;

        totalClicks += clicks;
        $('#totalClicks').text(totalClicks.toLocaleString());

        if(table){
            const rowNode = table.row.add([
                '#' + (table.rows().count()+1),
                `<a href="${url}" target="_blank">${url}</a>`,
                `<span class="short-url"><?=$fullUrl;?>/${code}</span> <button class="copy-btn">COPY</button>`,
                date,
                clicks
            ]).draw().node();
            $(rowNode).addClass('fade-in url-row');
        }

        $('#urlForm')[0].reset();
    });
});
</script>
</body>
</html>
