<?php
if (file_exists( __DIR__ . '/config.json')) {
    http_response_code(403);
    exit('Already installed');
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>XANTIBOT // INSTALL</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Fira+Code:wght@400;600&display=swap" rel="stylesheet">
    <style>
        body {
          font-family: 'Fira Code', monospace;
          background: #050505;
          color: #00ff41;
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center p-4">

    <div class="w-full max-w-lg bg-black border border-green-500/40 shadow-[0_0_20px_rgba(0,255,65,0.15)]">
        <div class="border-b border-green-500/30 p-4 text-center">
            <h1 class="text-xl font-bold tracking-widest">XANTIBOT INSTALL</h1>
            <p class="text-green-400/50 text-xs mt-1">INITIAL SYSTEM CONFIGURATION</p>
        </div>
        <form class="p-6 space-y-6" action="handler_xantibot/install.php" method="post">
            <div>
                <label class="block text-xs text-green-500/60 mb-1">API KEY</label>
                <input type="text" name="apikey" required placeholder="xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx" class="w-full bg-black border border-green-500/40 p-2 focus:outline-none focus:border-green-400">
                <a href="https://xantibot.pw/account/developer"
                   target="_blank"
                   class="text-xs text-green-500/40 hover:text-green-400">
                    Get your API key
                </a>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block text-xs text-green-500/60 mb-1">ADMIN USERNAME</label>
                    <input type="text" name="username" value="adroot" required class="w-full bg-black border border-green-500/40 p-2 focus:outline-none focus:border-green-400">
                </div>

                <div>
                    <label class="block text-xs text-green-500/60 mb-1">ADMIN PASSWORD</label>
                    <input type="password" name="password" value="adroot" required class="w-full bg-black border border-green-500/40 p-2 focus:outline-none focus:border-green-400">
                </div>
            </div>

            <div class="border border-green-500/30 p-4 bg-black">
                <h3 class="text-xs text-green-500/60 mb-3">BOT HANDLING</h3>
                <label class="flex items-center gap-3 mb-3 cursor-pointer">
                    <input type="radio" name="bot_action" value="challenge" checked class="accent-green-500 w-4 h-4">
                    <div>
                        <div class="font-semibold">Bot Challenge</div>
                    </div>
                </label>
                <label class="flex items-center gap-3 cursor-pointer">
                    <input type="radio" name="bot_action" value="redirect" class="accent-green-500 w-4 h-4">
                    <div class="w-full">
                        <input type="text" name="bot_redirect_path" placeholder="/blocked.html or https://google.com or https://example.com" class="w-full mt-2 bg-black border border-green-500/40 p-2 focus:outline-none focus:border-green-400">
                    </div>
                </label>
            </div>
            <button type="submit" class="w-full py-3 border border-green-500/50 hover:bg-green-500/10 transition">
                INSTALL
            </button>
        </form>
        <div class="border-t border-green-500/30 p-3 text-center text-xs text-green-500/40">
            PROTECTED BY XANTIBOT
        </div>

    </div>

</body>

</html>