<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Status: Operational</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Fira+Code:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Fira Code', monospace;
            background-color: #050505;
            color: #00ff41;
            overflow-x: hidden;
        }
        .crt::before {
            content: " ";
            display: block;
            position: absolute;
            top: 0;
            left: 0;
            bottom: 0;
            right: 0;
            background: linear-gradient(rgba(18, 16, 16, 0) 50%, rgba(0, 0, 0, 0.25) 50%), linear-gradient(90deg, rgba(255, 0, 0, 0.06), rgba(0, 255, 0, 0.02), rgba(0, 0, 255, 0.06));
            z-index: 2;
            background-size: 100% 2px, 3px 100%;
            pointer-events: none;
        }
        .typing-effect {
            overflow: hidden;
            border-right: .15em solid #00ff41;
            white-space: nowrap;
            animation: typing 3.5s steps(40, end), blink-caret .75s step-end infinite;
        }
        
        @keyframes typing {
            from { width: 0 }
            to { width: 100% }
        }
        
        @keyframes blink-caret {
            from, to { border-color: transparent }
            50% { border-color: #00ff41; }
        }
        .glitch {
            position: relative;
        }
        .glitch::before,
        .glitch::after {
            content: attr(data-text);
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
        }
        .glitch::before {
            left: 2px;
            text-shadow: -1px 0 #ff00c1;
            clip: rect(44px, 450px, 56px, 0);
            animation: glitch-anim 5s infinite linear alternate-reverse;
        }
        .glitch::after {
            left: -2px;
            text-shadow: -1px 0 #00fff9;
            clip: rect(44px, 450px, 56px, 0);
            animation: glitch-anim2 5s infinite linear alternate-reverse;
        }
        @keyframes glitch-anim {
            0% { clip: rect(31px, 9999px, 94px, 0); }
            20% { clip: rect(6px, 9999px, 3px, 0); }
            40% { clip: rect(67px, 9999px, 21px, 0); }
            60% { clip: rect(89px, 9999px, 5px, 0); }
            80% { clip: rect(24px, 9999px, 76px, 0); }
            100% { clip: rect(12px, 9999px, 54px, 0); }
        }
        
        @keyframes glitch-anim2 {
            0% { clip: rect(65px, 9999px, 99px, 0); }
            20% { clip: rect(4px, 9999px, 15px, 0); }
            40% { clip: rect(87px, 9999px, 91px, 0); }
            60% { clip: rect(2px, 9999px, 65px, 0); }
            80% { clip: rect(45px, 9999px, 23px, 0); }
            100% { clip: rect(12px, 9999px, 87px, 0); }
        }
        .scanline {
            width: 100%;
            height: 100px;
            z-index: 10;
            background: linear-gradient(0deg, rgba(0,0,0,0) 0%, rgba(0, 255, 65, 0.1) 50%, rgba(0,0,0,0) 100%);
            opacity: 0.1;
            position: absolute;
            bottom: 100%;
            animation: scanline 10s linear infinite;
            pointer-events: none;
        }
        @keyframes scanline {
            0% { bottom: 100%; }
            100% { bottom: -100%; }
        }

        .matrix-bg {
            background-image: radial-gradient(#003b00 15%, transparent 16%), radial-gradient(#003b00 15%, transparent 16%);
            background-size: 20px 20px;
            background-position: 0 0, 10px 10px;
            opacity: 0.2;
        }
    </style>
</head>
<body class="min-h-screen flex flex-col relative crt" style="height: auto; min-height: 100%;">
    <div class="fixed inset-0 matrix-bg pointer-events-none z-0"></div>
    <div class="scanline fixed"></div>
    <main class="flex-1 flex flex-col items-center justify-center p-4 md:p-8 relative z-10 w-full max-w-5xl mx-auto">
        <div class="w-full bg-black border border-green-500/50 shadow-[0_0_20px_rgba(0,255,65,0.2)] rounded-sm overflow-hidden flex flex-col">
            <div class="bg-green-900/20 border-b border-green-500/30 p-2 flex items-center justify-between">
                <div class="flex items-center gap-2">
                    <div class="w-3 h-3 rounded-full bg-red-500/80"></div>
                    <div class="w-3 h-3 rounded-full bg-yellow-500/80"></div>
                    <div class="w-3 h-3 rounded-full bg-green-500/80"></div>
                </div>
                <div class="text-xs text-green-500/70 font-mono">XANTIBOT</div>
                <div class="w-10"></div>
            </div>
            <div class="p-6 md:p-10 min-h-[400px] flex flex-col gap-4 text-sm md:text-base">
                <div class="my-8 flex flex-col items-center justify-center text-center">
                    <div class="mb-4 relative">
                        <svg class="w-24 h-24 text-green-500 animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <div class="absolute inset-0 bg-green-500 blur-xl opacity-20 animate-pulse"></div>
                    </div>
                    
                    <h1 class="text-4xl md:text-6xl font-bold mb-2 glitch tracking-tighter" data-text="SHORTLINK MANAGER">
                      SHORTLINK MANAGER
                    </h1>
                    <p class="text-green-400/60 text-lg md:text-xl max-w-md mx-auto">
                      Intelligent traffic filtering is running in real time.
                    </p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-auto border-t border-green-500/30 pt-6">
                    <div class="bg-green-900/10 border border-green-500/30 p-3">
                      <h3 class="text-xs text-green-500/50 mb-1">SERVER STATUS</h3>
                      <div id="server-status" class="flex items-center gap-2"></div>
                    </div>
                    
                    <div class="bg-green-900/10 border border-green-500/30 p-3">
                      <h3 class="text-xs text-green-500/50 mb-1">LATENCY</h3>
                      <div id="latency" class="font-mono">--</div>
                    </div>
                </div>
                <div class="mt-6 bg-green-900/10 border border-green-500/30 p-4 rounded-lg flex justify-center gap-4">
                    <a href="/manage.php" class="px-4 py-2 bg-green-500 hover:bg-green-600 text-white rounded transition">Login</a>
                    <a href="/install.php" class="px-4 py-2 border border-green-500 text-green-500 hover:bg-green-500 hover:text-white rounded transition">Install</a>
                </div>
            </div>
        </div>
        <footer class="mt-8 text-center text-xs text-green-500/40"><p>
            <a href="https://xantibot.pw"
               target="_blank"
               rel="noopener noreferrer"
               class="hover:text-green-400 transition">
               PROTECTED BY XANTIBOT
            </a>
          </p>
        </footer>

    </main>
    <script>
        async function pingServer(url) {
          const start = performance.now();
          try {
            const res = await fetch(url, {
              method: 'HEAD',
              cache: 'no-store',
              mode: 'no-cors'
            });
            const ms = Math.round(performance.now() - start);
            return { ok: true, ms };
          } catch (e) {
            return { ok: false, ms: null };
          }
        }
        
        async function updateStatus() {
          const statusEl = document.getElementById('server-status');
          const latencyEl = document.getElementById('latency');
        
          const result = await pingServer('https://xantibot.pw');
        
          if (result.ok) {
            statusEl.innerHTML = `
              <span class="w-2 h-2 bg-green-500 rounded-full animate-ping"></span>
              <span class="font-bold">ONLINE</span>
            `;
            latencyEl.innerHTML = `
              ${result.ms}ms <span class="text-xs text-green-500/50">stable</span>
            `;
          } else {
            statusEl.innerHTML = `
              <span class="w-2 h-2 bg-red-500 rounded-full"></span>
              <span class="font-bold text-red-500">OFFLINE</span>
            `;
            latencyEl.innerHTML = `
              -- <span class="text-xs text-red-500/50">timeout</span>
            `;
          }
        }
        updateStatus();
        setInterval(updateStatus, 2000);
    </script>
</body>
</html>