<?php
$data = json_decode(file_get_contents('php://input'), true);
$risk = 0;

// fingerprint
if (!empty($data['webdriver'])) $risk += 3;
if ($data['plugins'] === 0) $risk += 1;
if ($data['mouse_moves'] < 3) $risk += 2;
if ($data['timing_variance'] < 20) $risk += 2;

// IP / ASN (dummy example)
$ip = $_SERVER['REMOTE_ADDR'];
if (preg_match('/^(104\.|172\.)/', $ip)) $risk += 2;

// adaptive difficulty
function difficulty($risk) {
  if ($risk >= 7) return 6;
  if ($risk >= 4) return 5;
  if ($risk >= 2) return 4;
  return 0;
}

$diff = difficulty($risk);

if ($diff > 0) {
  session_start();
  $_SESSION['pow_nonce'] = bin2hex(random_bytes(8));
  $_SESSION['pow_diff']  = $diff;

  echo json_encode([
    'challenge' => 'pow',
    'nonce' => $_SESSION['pow_nonce'],
    'difficulty' => $diff
  ]);
  exit;
}

echo json_encode(['challenge' => 'none']);
